# Kurulum Sorun Giderme - 404 Hatası

## ❌ Problem: install.php 404 Hatası

Eğer `install.php` dosyasına erişirken 404 hatası alıyorsanız, şu çözümleri deneyin:

## ✅ Çözüm 1: Dosya Konumunu Kontrol Edin

`install.php` dosyası **mutlaka** `public/` klasöründe olmalı:

```
/public_html/
  └── public/
      ├── install.php  ← BURADA OLMALI
      ├── index.php
      └── .htaccess
```

**Kontrol:**
- cPanel File Manager'da `public` klasörüne gidin
- `install.php` dosyasının orada olduğundan emin olun

## ✅ Çözüm 2: .htaccess Kontrolü

`.htaccess` dosyası `public/` klasöründe olmalı ve doğru yapılandırılmış olmalı.

Eğer `.htaccess` dosyası yoksa veya yanlışsa, `public/.htaccess` dosyasını kontrol edin.

## ✅ Çözüm 3: Direkt URL Deneyin

Farklı URL formatlarını deneyin:

```
https://yourdomain.com/install.php
https://yourdomain.com/public/install.php
```

**Not:** Eğer `public` klasörü web root ise, direkt `/install.php` çalışmalı.

## ✅ Çözüm 4: index.php Üzerinden Erişim

`index.php` dosyası güncellendi. Artık kurulum yapılmamışsa otomatik olarak `install.php`'yi çalıştırır.

Sadece ana sayfaya gidin:
```
https://yourdomain.com/
```

Eğer kurulum yapılmamışsa, otomatik olarak kurulum sayfası açılacaktır.

## ✅ Çözüm 5: Manuel Kurulum (Alternatif)

Eğer `install.php` hiç çalışmıyorsa, manuel kurulum yapın:

### Adım 1: .env Dosyası Oluştur

`public` klasörünün bir üst dizininde `.env` dosyası oluşturun:

```env
APP_NAME="Ticket System"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=https://yourdomain.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=veritabani_adi
DB_USERNAME=kullanici_adi
DB_PASSWORD=şifre

SESSION_DRIVER=file
CACHE_DRIVER=file
```

### Adım 2: APP_KEY Oluştur

Online tool kullanın: https://generate-random.org/api-key-generator
- 32 karakterlik random string oluşturun
- `.env` dosyasında: `APP_KEY=base64:OLUŞTURULAN_KEY`

### Adım 3: SQL Dosyasını İçe Aktar

cPanel → phpMyAdmin:
- Veritabanınızı seçin
- **Import** sekmesi
- `database/ticket_system.sql` dosyasını seçin
- **Go** butonuna tıklayın

### Adım 4: Storage Klasörü

cPanel File Manager:
- `public/storage` klasörü oluşturun
- İçine `index.php` dosyası koyun: `<?php // Storage`

### Adım 5: İzinler

- `storage/` klasörü: 755
- `bootstrap/cache/` klasörü: 755

## 🔍 Dosya Yapısı Kontrolü

Doğru yapı şöyle olmalı:

```
/public_html/ (veya web root)
  ├── app/
  ├── bootstrap/
  ├── config/
  ├── database/
  │   └── ticket_system.sql
  ├── public/
  │   ├── install.php  ← BURADA
  │   ├── index.php
  │   └── .htaccess
  ├── resources/
  ├── routes/
  ├── storage/
  ├── vendor/
  ├── .env
  └── artisan
```

## ⚠️ Önemli Notlar

1. **Web Root:** Eğer `public` klasörü web root değilse, dosyaları bir üst dizine taşımanız gerekebilir
2. **PHP Versiyonu:** PHP 8.1+ olmalı
3. **vendor/ Klasörü:** Mutlaka yüklenmiş olmalı (composer install sonrası)

## 🆘 Hala Çalışmıyorsa

1. cPanel'den **Error Logs** kontrol edin
2. PHP versiyonunu kontrol edin (8.1+)
3. `vendor/` klasörünün yüklendiğinden emin olun
4. `.env` dosyasının doğru yerde olduğundan emin olun

## ✅ Başarı Kontrolü

Kurulum başarılıysa:
- Ana sayfa açılmalı
- `/admin/dashboard` erişilebilir olmalı
- Giriş yapabilmelisiniz

Başarılar! 🚀

